<?php include 'koneksi.php'; ?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Survey Kepuasan Pelanggan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Animate.css -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet">
  <!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Custom Style -->
  <!-- Tambahkan di dalam <style> -->
<style>
  .step { display: none; }
  .btn-emot {
    font-size: 6rem;
    border: none;
    background: none;
    cursor: pointer;
    transition: transform 0.3s ease, box-shadow 0.3s;
  }
  .btn-emot:hover {
    transform: scale(1.1);
    box-shadow: 0 0 15px rgba(0,0,0,0.2);
  }

  .survey-card {
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    border-radius: 20px;
  }

  .btn-option {
    margin: 8px 0;
    width: 100%;
    text-align: left;
  }

  @media (max-width: 576px) {
    .btn-emot {
      font-size: 4rem;
    }
  }
</style>

  
</head>
<body class="bg-light d-flex justify-content-center align-items-center vh-100">

<div class="container">
  <div class="card survey-card p-4 animate__animated animate__fadeIn">

   <!-- Ganti bagian emoji di STEP 1 dengan ini -->
<div id="step1" class="text-center py-5">
  <h1 class="mb-3 fw-bold fs-4">SURVEI KEPUASAN PELANGGAN</h1>
  <h2 class="mb-4 fw-semibold fs-5">Bagaimana pendapat Anda tentang layanan kami?</h2>
  <div class="d-flex flex-column flex-sm-row justify-content-center align-items-center gap-4">
    <div class="text-center">
      <button class="btn-emot" data-rating="baik" title="Sangat Baik">
      <img src="assets/gif/baik.gif" alt="Sangat Baik" class="img-fluid" style="height: 250px;">
    </button>
      <div class="mt-2 fw-semibold fs-5 text-dark">Sangat Baik</div>
    </div>
    <div class="text-center">
     <button class="btn-emot" data-rating="cukup" title="Cukup Baik">
      <img src="assets/gif/cukup.gif" alt="Cukup Baik" class="img-fluid" style="height: 250px;">
    </button>
      <div class="mt-2 fw-semibold fs-5 text-dark">Cukup Baik</div>
    </div>
    <div class="text-center">
      <button class="btn-emot" data-rating="kurang" title="Kurang Baik">
      <img src="assets/gif/kurang.gif" alt="Kurang Baik" class="img-fluid" style="height: 250px;">
    </button>
      <div class="mt-2 fw-semibold fs-5 text-dark">Kurang Baik</div>
    </div>
  </div>
</div>



    <!-- STEP 2 -->
    <div id="step2" class="step">
      <h5 class="mb-3">Pilih jenis layanan yang Anda nilai:</h5>
      <div class="d-grid gap-2">
        <button class="btn btn-outline-primary btn-option" data-layanan="Pinjaman">📄 Layanan Pinjaman</button>
        <button class="btn btn-outline-primary btn-option" data-layanan="Teller">💰 Layanan Teller</button>
        <button class="btn btn-outline-primary btn-option" data-layanan="CS">👩‍💼 Layanan CS</button>
      </div>
    </div>

    <!-- STEP 3 -->
    <div id="step3" class="step">
      <form action="simpan.php" method="POST">
        <h5 class="mb-3">Apa alasan Anda memberi penilaian tersebut?</h5>
        <input type="hidden" name="rating" id="inputRating">
        <input type="hidden" name="layanan" id="inputLayanan">
        <div class="form-check" id="alasan-options"></div>
        <div class="text-end mt-4">
          <button type="submit" class="btn btn-success">✅ Kirim Jawaban</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- JavaScript -->
<script>
let rating = "", layanan = "";

document.querySelectorAll('.btn-emot').forEach(el => {
  el.addEventListener('click', () => {
    rating = el.dataset.rating;
    document.getElementById('inputRating').value = rating;
    showStep('step2');
  });
});

document.querySelectorAll('.btn-option').forEach(el => {
  el.addEventListener('click', () => {
    layanan = el.dataset.layanan;
    document.getElementById('inputLayanan').value = layanan;
    loadAlasanOptions();
    showStep('step3');
  });
});

function showStep(id) {
  document.querySelectorAll('.step').forEach(step => step.style.display = 'none');
  document.getElementById(id).style.display = 'block';
}

function loadAlasanOptions() {
  const container = document.getElementById('alasan-options');
  let html = '';

  if (rating === 'baik') {
    html = `
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Layanan Cepat" required> 🚀 Layanan Cepat</label><br>
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Petugas Ramah" required> 😊 Petugas Ramah</label><br>
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Tempat Menyenangkan" required> 🏢 Tempat Menyenangkan</label><br>
    `;
  } else if (rating === 'cukup') {
    html = `
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Layanan cukup baik" required> Layanan cukup baik</label><br>
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Petugas cukup ramah" required> Petugas cukup ramah</label><br>
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Tempat biasa saja" required> Tempat biasa saja</label><br>
    `;
  } else {
    html = `
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Antrian Lama" required> ⌛ Antrian Lama</label><br>
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Petugas Tidak Ramah" required> 😐 Petugas Tidak Ramah</label><br>
      <label class="form-check-label"><input class="form-check-input" type="radio" name="alasan" value="Tempat Kurang Nyaman" required> 🏚 Tempat Kurang Nyaman</label><br>
    `;
  }

  container.innerHTML = html;
}

</script>

</body>
</html>
