<?php include '../koneksi.php'; ?>
<?php include 'auth.php'; ?>
<?php include 'layout/header.php'; ?>
<?php include 'layout/sidebar.php'; ?>

<style>
  @media (max-width: 768px) {
    .sidebar {
      display: none;
    }
    .content {
      margin-left: 0 !important;
    }
  }

  .content {
    margin-left: 250px;
    padding: 20px;
    padding-bottom: 80px;
  }
</style>

<div class="content">
  <?php if (isset($_SESSION['admin'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      Selamat datang, <strong><?= htmlspecialchars($_SESSION['admin']) ?></strong>!
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  <?php endif; ?>

  <div class="container py-5">
    <h2 class="mb-4 text-center fw-bold">Dashboard Survey Kepuasan Pelanggan</h2>

    <!-- Ringkasan -->
    <div class="row text-center mb-4">
      <div class="col-12 col-sm-6 col-md-4 mb-3">
        <div class="card p-3">
          <h5>Sangat Baik 😊</h5>
          <h2 id="countBaik">0</h2>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-4 mb-3">
        <div class="card p-3">
          <h5>Cukup Baik 🙂</h5>
          <h2 id="countCukup">0</h2>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-4 mb-3">
        <div class="card p-3">
          <h5>Kurang Baik 😞</h5>
          <h2 id="countKurang">0</h2>
        </div>
      </div>
    </div>

    <div class="mb-3 text-end">
      <button class="btn btn-outline-primary me-2" onclick="downloadChart('chartBar', 'chart-bar.png')">Unduh Bar Chart</button>
      <button class="btn btn-outline-success me-2" onclick="downloadChart('chartPie', 'chart-pie.png')">Unduh Pie Chart</button>
      <button class="btn btn-outline-danger" onclick="downloadChart('chartDoughnut', 'chart-doughnut.png')">Unduh Doughnut</button>
    </div>

    <!-- Grafik -->
    <div class="row text-center mb-4">
      <div class="col-12 col-md-4 mb-4">
        <div class="card p-3">
          <h6 class="fw-bold mb-3">Bar Chart</h6>
          <canvas id="chartBar" height="200"></canvas>
        </div>
      </div>
      <div class="col-12 col-md-4 mb-4">
        <div class="card p-3">
          <h6 class="fw-bold mb-3">Pie Chart</h6>
          <canvas id="chartPie" height="200"></canvas>
        </div>
      </div>
      <div class="col-12 col-md-4 mb-4">
        <div class="card p-3">
          <h6 class="fw-bold mb-3">Doughnut Chart</h6>
          <canvas id="chartDoughnut" height="200"></canvas>
        </div>
      </div>
    </div>

    <!-- Tabel Data -->
    <div class="card p-4">
      <h5 class="mb-3">Data Responden</h5>
      <div class="table-responsive">
        <table class="table table-bordered table-striped">
          <thead class="table-dark">
            <tr>
              <th>No</th>
              <th>Rating</th>
              <th>Layanan</th>
              <th>Alasan</th>
              <th>Waktu</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $no = 1;
            $query = mysqli_query($conn, "SELECT * FROM survey ORDER BY created_at DESC");
            while ($row = mysqli_fetch_assoc($query)) {
              echo "<tr>
                <td>" . $no++ . "</td>
                <td>{$row['rating']}</td>
                <td>{$row['layanan']}</td>
                <td>{$row['alasan']}</td>
                <td>{$row['created_at']}</td>
              </tr>";
            }
            ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="card mt-4">
      <div class="card-body">
        Ini adalah halaman utama dashboard admin.
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
let chartBar, chartPie, chartDoughnut;

function renderAllCharts(data) {
  const labels = ['Sangat Baik 😊', 'Cukup Baik 🙂', 'Kurang Baik 😞'];
  const values = [data.baik, data.cukup, data.kurang];
  const colors = ['#28a745', '#ffc107', '#dc3545'];

  // Bar
  const ctxBar = document.getElementById('chartBar').getContext('2d');
  chartBar = new Chart(ctxBar, {
    type: 'bar',
    data: {
      labels: labels,
      datasets: [{
        label: 'Jumlah Responden',
        data: values,
        backgroundColor: colors
      }]
    },
    options: {
      responsive: true,
      plugins: { legend: { display: false } },
      scales: {
        y: { beginAtZero: true }
      }
    }
  });

  // Pie
  const ctxPie = document.getElementById('chartPie').getContext('2d');
  chartPie = new Chart(ctxPie, {
    type: 'pie',
    data: {
      labels: labels,
      datasets: [{
        label: 'Jumlah Responden',
        data: values,
        backgroundColor: colors,
        borderColor: '#fff',
        borderWidth: 2
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'bottom' }
      }
    }
  });

  // Doughnut
  const ctxDoughnut = document.getElementById('chartDoughnut').getContext('2d');
  chartDoughnut = new Chart(ctxDoughnut, {
    type: 'doughnut',
    data: {
      labels: labels,
      datasets: [{
        label: 'Jumlah Responden',
        data: values,
        backgroundColor: colors,
        borderColor: '#fff',
        borderWidth: 2
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'bottom' }
      }
    }
  });
}

fetch('get_data.php')
  .then(res => res.json())
  .then(data => {
    document.getElementById('countBaik').textContent = data.baik;
    document.getElementById('countCukup').textContent = data.cukup;
    document.getElementById('countKurang').textContent = data.kurang;
    renderAllCharts(data);
  })
  .catch(err => console.error('Gagal memuat data chart:', err));
</script>

<script>
function downloadChart(canvasId, filename) {
  const canvas = document.getElementById(canvasId);
  const link = document.createElement('a');
  link.href = canvas.toDataURL('image/png');
  link.download = filename;
  link.click();
}
</script>

<?php include 'layout/footer.php'; ?>
