<?php include '../koneksi.php'; ?>
<?php include 'auth.php'; ?>
<?php include 'layout/header.php'; ?>
<?php include 'layout/sidebar.php'; ?>

<div class="content">
  <div class="container py-4">
    <h3 class="mb-4 fw-bold">Filter Data Survey per Tanggal</h3>

    <form method="GET" class="row g-3 mb-4">
      <div class="col-md-4">
        <label for="start" class="form-label">Dari Tanggal</label>
        <input type="date" id="start" name="start" class="form-control" value="<?= $_GET['start'] ?? '' ?>" required>
      </div>
      <div class="col-md-4">
        <label for="end" class="form-label">Sampai Tanggal</label>
        <input type="date" id="end" name="end" class="form-control" value="<?= $_GET['end'] ?? '' ?>" required>
      </div>
      <div class="col-md-4 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Tampilkan</button>
      </div>
    </form>
    <?php if (isset($_GET['start']) && isset($_GET['end'])): ?>
  <div class="card p-4 mb-4">
    <h5 class="mb-3">Grafik Responden (Filter Tanggal)</h5>
    <canvas id="chartFilter" height="100"></canvas>
  </div>
<?php endif; ?>


    <?php
if (isset($_GET['start']) && isset($_GET['end'])) {
  $start = $_GET['start'];
  $end = $_GET['end'];

  // Query untuk grafik
  $queryGrafik = mysqli_query($conn, "SELECT rating, COUNT(*) as total FROM survey WHERE DATE(created_at) BETWEEN '$start' AND '$end' GROUP BY rating");

  $baik = $cukup = $kurang = 0;
  while ($row = mysqli_fetch_assoc($queryGrafik)) {
    if ($row['rating'] == 'baik') $baik = $row['total'];
    elseif ($row['rating'] == 'cukup') $cukup = $row['total'];
    elseif ($row['rating'] == 'kurang') $kurang = $row['total'];
  }

  // Query untuk tabel
  $query = mysqli_query($conn, "SELECT * FROM survey WHERE DATE(created_at) BETWEEN '$start' AND '$end' ORDER BY created_at DESC");

  if (mysqli_num_rows($query) > 0) {
    echo "<div class='table-responsive'>";
    echo "<table class='table table-bordered table-striped'>
      <thead class='table-dark'>
        <tr>
          <th>No</th>
          <th>Rating</th>
          <th>Layanan</th>
          <th>Alasan</th>
          <th>Waktu</th>
        </tr>
      </thead>
      <tbody>";

    $no = 1;
    while ($row = mysqli_fetch_assoc($query)) {
  echo "<tr>
    <td>" . $no++ . "</td>
    <td>{$row['rating']}</td>
    <td>{$row['layanan']}</td>
    <td>{$row['alasan']}</td>
    <td>{$row['created_at']}</td>
  </tr>";
}

    echo "</tbody></table></div>";
  } else {
    echo "<div class='alert alert-warning'>Tidak ada data untuk rentang tanggal tersebut.</div>";
  }
}
?>

  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<?php if (isset($_GET['start']) && isset($_GET['end'])): ?>
<script>
const ctx = document.getElementById('chartFilter').getContext('2d');
new Chart(ctx, {
  type: 'bar',
  data: {
    labels: ['Sangat Baik 😊', 'Cukup Baik 🙂', 'Kurang Baik 😞'],
    datasets: [{
      label: 'Jumlah Responden',
      data: [<?= $baik ?>, <?= $cukup ?>, <?= $kurang ?>],
      backgroundColor: ['#28a745', '#ffc107', '#dc3545']
    }]
  },
  options: {
    responsive: true,
    plugins: {
      legend: { display: false }
    },
    scales: {
      y: {
        beginAtZero: true,
        precision: 0
      }
    }
  }
});
</script>
<?php endif; ?>

<?php include 'layout/footer.php'; ?>
